import 'package:admin_desktop/application/main/main_notifier.dart';
import 'package:admin_desktop/application/main/main_state.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:flutter/material.dart';
import 'package:remixicon_updated/remixicon_updated.dart';

import 'navigation_item.dart';

class CustomBottomBar extends StatelessWidget {
  final MainState state;
  final MainNotifier notifier;

  const CustomBottomBar(
      {super.key, required this.state, required this.notifier});

  @override
  Widget build(BuildContext context) {
    return Column(
      mainAxisAlignment: MainAxisAlignment.start,
      children: [
        NavigationItem(
          selectIcon: Remix.home_smile_fill,
          icon: Remix.home_smile_line,
          title: TrKeys.home,
          onTap: () => notifier.changeIndex(0),
          isActive: state.selectIndex == 0,
          titleActive: state.active,
        ),
        if (AppHelpers.getUserRole != TrKeys.master &&
            AppHelpers.getProductsEnabled())
          NavigationItem(
            selectIcon: Remix.shopping_bag_fill,
            icon: Remix.shopping_bag_line,
            title: TrKeys.order,
            onTap: () => notifier.changeIndex(1),
            isActive: state.selectIndex == 1,
            titleActive: state.active,
          ),
        NavigationItem(
          selectIcon: Remix.calendar_todo_fill,
          icon: Remix.calendar_todo_line,
          title: TrKeys.schedule,
          onTap: () => notifier.changeIndex(2),
          isActive: state.selectIndex == 2,
          titleActive: state.active,
        ),
        NavigationItem(
          selectIcon: Remix.chat_1_fill,
          icon: Remix.chat_1_line,
          title: TrKeys.comments,
          onTap: () => notifier.changeIndex(3),
          isActive: state.selectIndex == 3,
          titleActive: state.active,
        ),
        NavigationItem(
          selectIcon: Remix.money_dollar_circle_fill,
          icon: Remix.money_dollar_circle_line,
          title: TrKeys.saleHistory,
          onTap: () => notifier.changeIndex(4),
          isActive: state.selectIndex == 4,
          titleActive: state.active,
        ),
        NavigationItem(
          selectIcon: Remix.pie_chart_fill,
          icon: Remix.pie_chart_line,
          title: TrKeys.income,
          onTap: () => notifier.changeIndex(5),
          isActive: state.selectIndex == 5,
          titleActive: state.active,
        ),
        NavigationItem(
          selectIcon: Remix.pie_chart_fill,
          icon: Remix.pie_chart_line,
          title: TrKeys.booking,
          onTap: () => notifier.changeIndex(6),
          isActive: state.selectIndex == 6,
          titleActive: state.active,
        ),
        NavigationItem(
          selectIcon: Remix.box_1_fill,
          icon: Remix.box_1_line,
          title: TrKeys.sections,
          onTap: () => notifier.changeIndex(7),
          isActive: state.selectIndex == 7,
          titleActive: state.active,
        ),
      ],
    );
  }
}
